/** @file   progressindicator.h
 * @brief   Declarations of ProgressIndicator class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:38 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_PROGRESSINDICATOR_H
#define H_WWW_PROGRESSINDICATOR_H

#include "eng2d_dll.h"
#include "Gradient.h"

// Forward declarations
struct BITMAP;

namespace eng2d {


/** @class  ProgressIndicator
 * @brief   Displays the progress bar
 * @author  Tomi Lamminsaari
 * 
 * ProgressIndicator represents simple progressbar we use during the
 * slow operation to show user the remaining time.
 */
class DLLIMPORT ProgressIndicator
{
public:
  
  ///
  /// Constants and static members
  /// ============================
  
  /** The color we use when drawing the borders of ProgressBar. */
  static eng2d::Color borderColor;
  /** The color gradient we use when drawing the bar itself. */
  static eng2d::Gradient fillGradient;
  

  ///
  /// Constructors, Destructor and operators
  /// ======================================

  /** Constructs new ProgressBar.
   * @param     totalSteps        How many steps.
   */
  ProgressIndicator(int totalSteps);
  /** Constructs new ProgressBar and sets the target bitmap.
   * @param     totalSteps        How many steps
   * @param     pTarget           Pointer to target bitmap
   */
  ProgressIndicator(int totalSteps, BITMAP* pTarget);
  /** Copy constructor. */
  ProgressIndicator(const ProgressIndicator& rO);
  /** Destructor. */
  virtual ~ProgressIndicator();
  /** Operator = */
  ProgressIndicator& operator = (const ProgressIndicator& rO);


  ///
  /// Methods
  /// =======

  /** Sets the current state of progress.
   * @param     step              Current state.
   */
  void setStep(int step);
  /** Advances the progressbar. */
  void advance();
  /** Redraws the ProgressIndicator. It will be drawn on the bitmap given
   * to the constructor.
   */
  virtual void redraw();
  
  /** Sets the position where to draw the progressbar.
   * @param     x                 The x-coordinate
   * @param     y                 The y-coordinate
   */
  void position(int x, int y);
  
  /** Sets the size of the progressbar
   * @param     w                 Width
   * @param     h                 Height
   */
  void size(int w, int h);


  ///
  /// Getter-methods
  /// ==============
  
  /** Returns the current step.
   * @return    How many steps we've already advanced.
   */
  int currentStep() const;
  
  /** Returns the total number of steps.
   * @return    Total number of steps.
   */
  int totalSteps() const;
  

protected:



  ///
  /// Members
  /// =======

  /** The current state of progression. When this reaches the 'm_totalSteps'
   * we've done.
   */
  int m_currentStep;
  
  /** Total number of steps. */
  int m_totalSteps;
  
  /** X-coordinate of the topleft corner of the progressbar. */
  int m_posX;
  /** Y-coordinate of the topleft corner of the progressbar. */
  int m_posY;
  /** Width of the progressbar. */
  int m_width;
  /** Height of the progressbar. */
  int m_height;
  
  /** The target bitmap */
  BITMAP* m_pTarget;
};


};  // end of namespace


#endif

/**
 * Version history
 * ===============
 * $Log: progressindicator.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:38  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:19:48+02  lamminsa
 * Initial revision
 *
 */
